//Lab. 06: Map constant damping ratio loci from s-plane to z-plane 

//              scilab - 5.5.1
//              Operating System : Windows 7, 32-bit
//*****************************************************************************
//Clean the environment
close;
clear;
clc;

// System model
s=poly(0,'s');
Ts=0.2;
//*****************************************************************************
// S-plane pole-zero map for the continuous time system
//*****************************************************************************
for w=0:0.2:19
    sigma=w;
    num=1;
    den=poly([-sigma+%i*w, -sigma-%i*w],'s');
    g=syslin('c',num./den);
    plzr(g)
end
sgrid()
title('S-plane pole-zero map for the constant damping ratio loci','fontsize',3)

// Zoom axes for clarity

zoom_rect([-20 -22 20 22])

//*****************************************************************************
//Z-plane pole-zero map for the sample data system
//*****************************************************************************
   figure;
for w=0:0.2:19
    sigma=w;
    num=1;
    den=poly([-sigma+%i*w, -sigma-%i*w],'s');
    g=syslin('c',num./den);
    gz=dscr(g,Ts)
    plzr(gz);
end
zgrid();
f=get("current_figure") //Current figure handle                
f.background=8
title('Z-plane pole-zero map for the constant damping ratio loci','fontsize',3)

// Zoom axes for clarity
zoom_rect([-1.2 -1.2 1.2 1.2])
